<?php session_start();
include '../db.php';

$page = "school";
$action = $_GET['action'];

if ($_POST['submit']) {

    $saveAry = array(
        "school_name"   =>  $_POST["school_name"],
        "contact"       =>  $_POST["contact"],
        "email"         =>  $_POST["email"],
        "website"       =>  $_POST["website"],
        "address"       =>  $_POST["address"],
        "status"        =>  $_POST['status'],
        "added_by"      =>  $_SESSION["admin"]["uid"],
        // "added_role"    =>  "Super Admin",
    );

    if(isset($_FILES["logo"]["name"]) && !empty($_FILES["logo"]["name"])){
		$lfilename = basename($_FILES['logo']['name']);
		$lext = strtolower(substr($lfilename, strrpos($lfilename, '.')+1));
		$lnewfile=md5(microtime()).".".$lext;
		if(move_uploaded_file($_FILES['logo']['tmp_name'],"../uploads/logo/".$lnewfile))
		{
			$saveAry["logo"]=$lnewfile;
		}
	}

    if ($_GET['action'] == "add") {
        $flg = $db->insertAry("schools", $saveAry);
        if(!is_null($flg)){
            echo "<script>alert('School added successfully.')</script>";
            redirect("$page");
        } else {
            echo "<script>alert('Something went wrong. Please try again.')</script>";
        }
    }

    if ($_GET['action'] == "edit" && $_GET['id'] != '') {
        $flg = $db->updateAry("schools", $saveAry, "where id='$_GET[id]' ");

        echo "<script>alert('Updated successfully.')</script>";
        redirect("$page");
    }
}

?>
<html>

<head>
    <?php include 'meta.php'; ?>
</head>

<body>
    <?php include 'header.php'; ?>

    <div class="container-fluid">

        <div class="row">

            <div class="col-md-2 col-3">
                <?php include 'sidebar.php'; ?>
            </div>
            <div class="col-md-10 col-9">

                <div class="inner-div">

                    <?php if (($action == "add") || ($action == "edit" && $_GET['id'] != "")) {
                        if ($action == "edit" && $_GET['id'] != "") {
                            $school = $db->getRow("select * from schools where id=$_GET[id] ");
                        }
                    ?>

                        <h2 class="top-heading"><?php echo $page; ?> Details</h2>

                        <form method="post" enctype="multipart/form-data">

                            <div class="form-group">
                                <label>School Name <span class="mandatory">*</span></label>
                                <input type="text" name="school_name" value="<?php echo $school['school_name']; ?>" required />
                            </div>

                            <div class="form-group">
                                <label>Contact No.</label>
                                <input type="text" name="contact" value="<?php echo $school['contact']; ?>" />
                            </div>

                            <div class="form-group">
                                <label>Email</label>
                                <input type="email" name="email" value="<?php echo $school['email']; ?>" />
                            </div>

                            <div class="form-group">
                                <label>Website</label>
                                <input type="text" name="website" value="<?php echo $school['website']; ?>" />
                            </div>

                            <div class="form-group">
                                <label style="margin-top:15px;float:left;">Address</label>
                                <textarea name="address"><?php echo $school['address']; ?></textarea>
                            </div>

                            <div class="form-group">
                                <label>Status <span class="mandatory">*</span></label>
                                <select name="status" id="status">
                                    <option value="1" <?php if ($school['status'] === 1) echo "selected"; ?>>Active</option>
                                    <option value="0" <?php if ($school['status'] === 0) echo "selected"; ?>>Inactive</option>
                                </select>
                            </div>

                            <div class="form-group mt-2">
                                <label>School Logo</label>
                                <input type="file" name="logo" />
                            </div>

                            <div class="text-center">
                                <input type="submit" name="submit" value="Submit" />
                            </div>


                        </form>
                    <?php } else {
                        $allschools = $db->getRows("select * from schools");
                    ?>

                        <h2 class="top-heading"><?php echo $page; ?> List
                            <a href="<?php echo $page ?>?action=add" class="btn btn-success">Add <?php echo $page; ?></a>
                        </h2>

                        <table class="table table-striped table-sm">
                            <thead class="table-success">
                                <tr>
                                    <th>S.No.</th>
                                    <th>School Name</th>
                                    <th>Contact</th>
                                    <th>Email</th>
                                    <th>Website</th>
                                    <th>Address</th>
                                    <th>Logo</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($allschools as $school) {
                                    $i++; ?>
                                    <tr>
                                        <td><?php echo $i; ?></td>
                                        <td><?php echo $school['school_name']; ?></td>
                                        <td><?php echo $school['contact']; ?></td>
                                        <td><?php echo $school['email']; ?></td>
                                        <td><a href="<?php echo $school['website']; ?>" target="_blank"><?php echo $school['website']; ?></a></td>
                                        <td><?php echo $school['address']; ?></td>
                                        <td><img src="../uploads/logo/<?php echo $school['logo']; ?>" alt="School Logo" style="width:50px;">  </td>
                                        <td>
                                            <a href="<?php echo $page; ?>?action=edit&id=<?php echo $school['id']; ?>">
                                                <button class="btn btn-success edit-btn">Edit</button>
                                            </a>
                                            <button onclick="delete_school(<?php echo $school['id']; ?>)" class="btn btn-danger delete-btn">Delete</button>
                                        </td>
                                    </tr>

                                <?php } ?>

                            </tbody>
                        </table>

                    <?php
                    }

                    ?>

                </div>

            </div>

        </div>

    </div>
    <?php include 'footer.php'; ?>

    <script>
        function delete_school(id) {
            if (confirm("Are you sure want to delete this school?") == true) {
                $.post("ajax.php", {
                    type: "delete_school",
                    id: id
                }, function(data) {
                    alert(data);
                    location.reload();
                });
            }
        }
    </script>

</body>

</html>